define(['modules/appointments/cancellation/cancellation-popup-view'], function(CancellationView) {
    'use strict';

    describe('Cancellation Popup View', function() {
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            spyOn(CancellationView.prototype, 'trigger');
            view = new CancellationView({
                modelType: 'request',
                elAfterClose: $('.element-for-focus'),
            });

            $('body').append('<a class="element-for-focus" href="#"></a>');

            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h3').text()).toEqual('Confirmation');
        });

        it('has a message with the modelType text', function() {
            var expectedText = [
                'Are you sure you want to cancel this request?',
                'Select Yes to cancel, No to return to the Request details page.',
            ];
            expect($view.find('.ui-content p:first-of-type').text()).toEqual(expectedText[0]);
            expect($view.find('.ui-content p:nth-of-type(2)').text()).toEqual(expectedText[1]);
        });
        it('has Yes and No buttons', function() {
            expect($view.find('button, a[role=button]').length).toEqual(2);

            expect($view.find('.warning-continue-btn').attr('id')).toEqual('request-cancellation-continue-btn');
            expect($view.find('#request-cancellation-continue-btn').text()).toEqual('Yes');

            expect($view.find('.warning-return-btn').attr('id')).toEqual('request-cancellation-return-btn');
            expect($view.find('#request-cancellation-return-btn').text()).toEqual('No');
        });

        it('has the Yes button before the No button', function() {
            expect($view.find('#request-cancellation-continue-btn + #request-cancellation-return-btn').length).toEqual(1);
        });

        it("triggers 'appointment:cancel:confirmed' when the Yes button is clicked", function() {
            $view.find('#request-cancellation-continue-btn').click();
            expect(view.trigger).toHaveBeenCalledWith('appointment:cancel:confirmed');
        });
    });
});
